#!/bin/bash
SHADOW_MODEL_IDX=$1
NUM_SHADOW=$2

SEED=0

# Shared HPs
AUGMULT_FACTOR="8"
LEARNING_RATE="4.0"
MAX_GRAD_NORM="1.0"

# Specific HPs
BATCH_SIZE="1024"
NUM_EPOCHS="200"
NOISE_MULTIPLIER="0.4"

NUM_CANARIES=500
CANARY_TYPE="label_noise"
NUM_POISON=0
POISON_TYPE="canary_duplicates_noisy"

DATA_PATH="datasets"
LIRA_PATH="exps/dpsgd_low/lira"


python -u src/dpsgd/dpsgd.py \
 --data_path "${DATA_PATH}" \
 --lira_path "${LIRA_PATH}" \
 --seed "${SEED}" --num-shadow "${NUM_SHADOW}" \
 --num-canaries "${NUM_CANARIES}" --canary-type "${CANARY_TYPE}" \
 --num-poison "${NUM_POISON}" --poison-type "${POISON_TYPE}" \
 --exp_id "${SHADOW_MODEL_IDX}" \
 --augmult-factor "${AUGMULT_FACTOR}" --learning-rate "${LEARNING_RATE}" --max-grad-norm "${MAX_GRAD_NORM}" \
 --batch-size "${BATCH_SIZE}" --noise-multiplier "${NOISE_MULTIPLIER}" --num-epochs "${NUM_EPOCHS}" \
